/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.powers;

import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.actions.common.ChangeStateAction;
import com.megacrit.cardcrawl.actions.common.GainBlockAction;
import com.megacrit.cardcrawl.actions.common.RemoveSpecificPowerAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.localization.PowerStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.AbstractPower;

public class CurlUp
extends AbstractPower {
    public static final String POWER_ID = "Curl Up";
    private static final PowerStrings powerStrings = CardCrawlGame.languagePack.getPowerStrings("Curl Up");
    public static final String NAME = CurlUp.powerStrings.NAME;
    public static final String[] DESCRIPTIONS = CurlUp.powerStrings.DESCRIPTIONS;
    private final int blockAmt = MathUtils.random(3, 7);
    private boolean triggered = false;

    public CurlUp(AbstractCreature owner) {
        this.name = NAME;
        this.ID = POWER_ID;
        this.owner = owner;
        this.amount = this.blockAmt;
        this.description = DESCRIPTIONS[0] + FontHelper.colorString(Integer.toString(this.amount), "b") + DESCRIPTIONS[1];
        this.img = ImageMaster.loadImage("images/powers/32/closeUp.png");
    }

    @Override
    public int onAttacked(DamageInfo info, int damageAmount) {
        if (!this.triggered && damageAmount < this.owner.currentHealth && damageAmount > 0 && info.owner != null && info.type == DamageInfo.DamageType.NORMAL) {
            this.flash();
            this.triggered = true;
            AbstractDungeon.actionManager.addToBottom(new ChangeStateAction((AbstractMonster)this.owner, "CLOSED"));
            AbstractDungeon.actionManager.addToBottom(new GainBlockAction(this.owner, this.owner, this.blockAmt));
            AbstractDungeon.actionManager.addToBottom(new RemoveSpecificPowerAction(this.owner, this.owner, POWER_ID));
        }
        return damageAmount;
    }
}

